require( "scripts/style.lua" );


InfoFont = {
  standardFont,
  18,
  BorderColor
};

MPInfoFont = {
  standardFont,
  20,
  BorderColor
};

WinnerFont = {
  standardFont,
  20,
  BorderColor
};

local showChatWindow = MultiPlayerGame(false);
--uncomment the following to make practice mode behave like
--normal mode and show the chat window
--showChatWindow = true;

if (showChatWindow) then
	backgroundimage="multi/mp_level_over_chat";
else
	backgroundimage="backgrounds/longdialog";
end


function MakeFloWindows()
	if (showChatWindow) then
		flo1x = 285;
		flo1y = 90;
		flo2x = 385;
		flo2y = 90;
		flo1WinnerX = 325;
	else
		flo1x = 125;
		flo1y = 130;
		flo2x = 300;
		flo2y = 130;
		flo1WinnerX = 220;
	end
	player1score = GetScore(0);
	player2score = GetScore(1);
	winnertext = '';
	iwon = true;
	if (GetMultiplayerMode()==1) then
		if (player1score == player2score) then
			winnertext = '#'..GetString('mptie');
		elseif (player1score < player2score) then
			winnertext = '#'..GetString('mp_comp_winner', GetUserNamePlayerNumber(1));
			if (GetMyPlayerNum() == 1) then
				iwon = true;
			else
				iwon = false;
			end	
		else
			winnertext = '#'..GetString('mp_comp_winner', GetUserNamePlayerNumber(0));
			if (GetMyPlayerNum() == 1) then
				iwon = false;
			else
				iwon = true;
			end
		end
	end
	winnertextx = 20;
	winnertextw = kMax - 20;
	winnertexty = 30;
	winnertexth = 30;
	if (showChatWindow) then
		winnertexty = 150;
	end
	
	if (GetMultiplayerMode()==0 or player1score == player2score) then
		return Group {
			AutoFitText
			{
				x = winnertextx,
				w = winnertextw,
				y = winnertexty,
				h = winnertexth,
				label = winnertext,
				font = WinnerFont,
				flags = kHAlignCenter + kVAlignTop
			};
			
			FloWindow
			{	
				x = flo1x,
				y = flo1y,
				frame = 2
			};			
			
			FloWindow
			{
				x = flo2x,
				y = flo2y,
				frame = 2,
				opponent = true
			};			
		}
	else
		return Group {
			AutoFitText
			{
				x = winnertextx,
				w = winnertextw,
				y = winnertexty,
				h = winnertexth,
				label = winnertext,
				font = WinnerFont,
				flags = kHAlignCenter + kVAlignTop
			};
			
			FloWindow
			{	
				x = flo1WinnerX,
				y = flo1y,
				frame = 2,
				opponent = not iwon;
			};
		}
	end
end

function MakeMPStatText()
	if (GetMultiplayerMode()==0) then
		goodwork = '#'..GetString('mp_coop_goodwork', GetUserName(false), GetUserName(true));
		numserved = '#'..GetString('mp_coop_numserved', ''..(GetTablesServed(0) + GetTablesServed(1)));
		minutes = GetGameMinutes();
		seconds = GetGameSeconds();
		if (minutes == 1) then
			minutestr = GetString('minute');
		else
			minutestr = GetString('minutes');
		end
		if (seconds == 1) then
			secondstr = GetString('second');
		else
			secondstr = GetString('seconds');
		end
		
		lasted = '#'..GetString('mp_coop_lasted', ''..minutes, minutestr, ''..seconds, secondstr);
		totalScore = GetScore(0) + GetScore(1);
		finalscore = '#'..GetString('mp_coop_final_score', ''..totalScore);
		if (showChatWindow) then
			return Group {
				Text
				{
					font = MPInfoFont,
					x=30,y=150,w=kMax-30,h=75,
					flags = kHAlignCenter + kVAlignTop,
					label = goodwork
				};	
				
				Text
				{
					font = MPInfoFont,
					x=30,y=180,w=kMax-30,h=75,
					flags = kHAlignCenter + kVAlignTop,
					label = numserved
				};	
				
				
				Text
				{
					font = MPInfoFont,
					x=30,y=210,w=kMax-30,h=75,
					flags = kHAlignCenter + kVAlignTop,
					label = lasted
				};
				
				Text
				{
					font = MPInfoFont,
					x=30,y=240,w=kMax-30,h=75,
					flags = kHAlignCenter + kVAlignTop,
					label = finalscore
				};			
			}
		else
			return Group {
				Text
				{
					font = MPInfoFont,
					x=30,y=170,w=kMax-30,h=75,
					flags = kHAlignCenter + kVAlignTop,
					label = goodwork
				};	
				
				Text
				{
					font = MPInfoFont,
					x=30,y=220,w=kMax-30,h=75,
					flags = kHAlignCenter + kVAlignTop,
					label = numserved
				};	
				
				
				Text
				{
					font = MPInfoFont,
					x=30,y=280,w=kMax-30,h=75,
					flags = kHAlignCenter + kVAlignTop,
					label = lasted
				};
				
				Text
				{
					font = MPInfoFont,
					x=30,y=320,w=kMax-30,h=75,
					flags = kHAlignCenter + kVAlignTop,
					label = finalscore
				};			
			}
		end
	else
		player1Score = GetScore(0);
		player2Score = GetScore(1);
		
		if (player1Score == player2Score) then
			stattext = '#'..GetString('mp_comp_winner_tie', GetUserName(true), GetUserName(false));
		else 
			if (player1Score < player2Score) then
				winningScore = player2Score;
				losingScore = player1Score;
				winner = GetUserNamePlayerNumber(1);
				loser = GetUserNamePlayerNumber(0);
			else
				winningScore = player1Score;
				losingScore = player2Score;
				winner = GetUserNamePlayerNumber(0);
				loser = GetUserNamePlayerNumber(1);
			end
			if (winningScore >= (losingScore * 2)) then 
				stattext = '#'..GetString('mp_comp_winner_1', winner, loser);
			elseif (winningScore >= (losingScore * 1.5)) then
				stattext = '#'..GetString('mp_comp_winner_2', winner, loser);
			else
				stattext = '#'..GetString('mp_comp_winner_3', winner, loser);
			end
		end
		finalScore = '#'..GetString('mp_comp_finalscore', GetUserNamePlayerNumber(0), ''..GetScore(0), GetUserNamePlayerNumber(1), ''..GetScore(1));
		
		if (showChatWindow) then
			stattextx = 30;
			stattextw = 250;
			stattexty = 180;
			finalscorex = 325;
			finalscorew = kMax;
			finalscorey = 180;
		else
			stattexty = 200;
			stattextx = 30;
			stattextw = kMax-30;
			finalscorex = 30;
			finalscorew = kMax-30;
			finalscorey = 270;
		end
		return Group {
			Text
			{
				font = MPInfoFont,
				x=stattextx,y=stattexty,w=stattextw,h=150,
				flags = kHAlignCenter + kVAlignTop,
				label = stattext
			};
			Text
			{
				font = MPInfoFont,
				x=finalscorex,y=finalscorey,w=finalscorew,h=150,
				flags = kHAlignCenter + kVAlignTop,
				label = finalScore
			};
		}
	end
end


kLevelDoneText = '#'..GetMPDoneText();
kLevelScoreText = '#'..GetMPScoreText();



function MakeMPLevelOverButtons(  )

	if (not showChatWindow) then
		return Group
		{
			SetStyle(StandardButtonStyle);
			
			Button
			{
				x=kCenter,
				y=350,
				name="rematch",
				label="mpplaytutorialagain",
				type = kPush,
				command=
						function()
							PopModal("scripts/mplevelover.lua");
							RestartLevel();
							PauseGame(false);
						end
			},
			
			
			
			Button
			{
				x=kCenter,
				y=393,
				name="lobby",
				label='quit',
				type = kPush,
				command=
						function()
							QuitGame(false);
							PopModal("scripts/game.lua");
							DoModal("scripts/mpentry.lua");
						end
			},
		}
	else
		return Group
		{
			SetStyle(StandardButtonStyle);
			Button
			{
				x=150,
				y=260,
				name="rematch",
				label="rematch",
				type = kPush,
				command=
						function()
							if (MultiPlayerGame(false) == true) then
								MetricEvent(eMPRematchEvent);
								RequestRematch();
								local result = DisplayDialog{ 
									"scripts/ok.lua",
									body="mprematchwait",
									oklabel="cancel"
								};
								
								if (result == 'ok') then
									CancelRematch();
								end
							else
								PopModal("scripts/mplevelover.lua");
								RestartLevel();
								PauseGame(false);
							end
						end
			},
			
			Button
			{
				x=350,
				y=260,
				name="lobby",
				label='lobby',
				type = kPush,
				command=
						function()
							QuitGame(false);
							PopModal("scripts/game.lua");
						end
			},
		}
	end
end


function MakeEmbeddedOutroChatWindow(showChatWindow, chatInfoText)
	if (showChatWindow) then
		

		return Group {
			--MakeIGChatWindow();
			SetStyle(SmallButtonStyle);
			AutoFitText
			{
				x = 0, w=kMax;
				y = 330, h = 50;
				flags = kHAlignCenter + kVAlignTop,
				label = chatInfoText,
				font = ChatInfoFont
			};
						SetStyle(ChatScrollArrowStyle);
			Button
			{
				x = 577, y = 335,
				command =
					function()
						ChatArrow(false);
					end
			};
			
			Button
			{
				x = 577, y = 457,
				vflip = true,
				command =
					function()
						ChatArrow(true);
					end
			};
			SetStyle(ChatScrollStyle);
			ScrolledWindow
			{
				x=35,y=354,w=562,h=104,
				name='chatscroller',
				Text
				{
					x = 0, y = 0, w = kMax-25, h = kMax,
					name="embeddedchatoutput",
					font=ChatFont,
					label='',
					flags=kHAlignLeft+ kVAlignTop,
					padding=0
				},
			},
			SetStyle(DefaultStyle);

			TextEdit 
			{
				name="embeddedchatentry",
				label=GetString("mpentertexthere"),
				font=ChatFont,
				length=100,
				clearinitial = true,
				flags=kHAlignLeft+ kVAlignCenter,
				x=35,y=461,w=455,h=27
			},
			Text
			{
				x= 0,
				y = 520,
				w = kMax,
				h = kMax,
				font = ChatTOSFont,
				flags = kHAlignCenter + kVAlignTop,
				label = 'mp_chat_tos'
			},
			SetStyle(SmallestButtonStyle);
			Button
			{
				x = 492,
				y = 461,
				label = 'mpsendchat',
				name = 'chatsend',
				default = true,
				command = 
					function()
						ChatSendButton();
					end
			};
		}
	else
		return Group {
		
		}
	end
end   



if (IsMPTutorialLevel()) then
	MakeDialog
	{				
		Window
		{
			x=0,y=0,w=800,h=600,
			name="overbackground",
			Bitmap
			{
				name="backgroundimage",
				image="backgrounds/small_levelover",
				x=kCenter,
				y=kCenter,
				
				Text
				{
					font = InfoFont,
					x=43,y=25,w=215,h=150,
					flags = kHAlignLeft + kVAlignTop,
					label = kLevelDoneText
				};
				
				Text
				{
					font = InfoFont,
					x=43,y=176,w=215,h=163,
					flags = kHAlignLeft + kVAlignTop,
					label = kLevelScoreText
				};
		
				SetStyle(StandardButtonStyle);
				Button
				{
					x=kCenter,
					y=250,
					name="playmultiplayer",
					label="mptutorialgotomp",
					type = kPush,
					command=
							function()
								QuitGame(false);
								PopModal("scripts/game.lua");
								EnterMultiplayer();
								
							end
				},
				
				Button
				{
					x=kCenter,
					y=300,
					name="rematch",
					label="mpplaytutorialagain",
					type = kPush,
					command=
							function()
								PopModal("scripts/mplevelover.lua");
								RestartLevel();
								PauseGame(false);
							end
				},
				
				
				
				Button
				{
					x=kCenter,
					y=350,
					name="lobby",
					label='quit',
					type = kPush,
					command=
							function()
								QuitGame(false);
								PopModal("scripts/game.lua");
							end
				},
									
				SetStyle(DefaultStyle);					
			},
		},
	}
else 
	MakeDialog
	{				
		Window
		{
			x=0,y=0,w=800,h=600,
			name="overbackground",
			Bitmap
			{
				name="backgroundimage",
				image=backgroundimage,
				x=kCenter,
				y=kCenter,
				
				
		
				
				MakeMPLevelOverButtons();
				MakeFloWindows();
				MakeMPStatText();
				SetStyle(DefaultStyle);
				MakeEmbeddedOutroChatWindow(showChatWindow, '');
			},
		},
	}
end

if (showChatWindow) then
	AdoptChatWindow();
	SetEmbeddedChatMode(true, 7);
end